using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace test1
{
    internal class Program
    {
        class Tacka
        {
            public long x;
            public long y;
            public Tacka(long x, long y) { this.x = x; this.y = y; }
        }

        class Mnogougao
        {
            int n;
            List<Tacka> tacke;
            List<Tacka> omotac;
            long mod = 1000000000;

            public void napraviMnogougao()
            {
                n = int.Parse(Console.ReadLine());
                tacke = new List<Tacka>();

                string[] s;
                for (int i = 0; i < n; i++)
                {
                    s = Console.ReadLine().Split();
                    tacke.Add(new Tacka(long.Parse(s[0]), long.Parse(s[1])));
                }
            }

            public long vektorskiProizvod(Tacka t1, Tacka t2, Tacka t3)
            {
                return ((t2.x - t1.x) % mod * (t3.y - t1.y) % mod) % mod - ((t2.y - t1.y) % mod * (t3.x - t1.x) % mod) % mod;
            }

            public void odrediOmotac()
            {
                omotac = new List<Tacka>();

                tacke.Sort((tacka1, tacka2) => tacka1.x == tacka2.x ? tacka1.y.CompareTo(tacka2.y) : tacka1.x.CompareTo(tacka2.x));

                List<Tacka> gornjaPolovina = new List<Tacka>();
                for (int i = 0; i < n; i++)
                {
                    while (gornjaPolovina.Count >= 2 && vektorskiProizvod(gornjaPolovina[gornjaPolovina.Count - 2], gornjaPolovina[gornjaPolovina.Count - 1], tacke[i]) < 0) gornjaPolovina.RemoveAt(gornjaPolovina.Count - 1);
                    gornjaPolovina.Add(tacke[i]);
                }

                List<Tacka> donjaPolovina = new List<Tacka>();
                for (int i = n - 1; i >= 0; i--)
                {
                    while (donjaPolovina.Count >= 2 && vektorskiProizvod(donjaPolovina[donjaPolovina.Count - 2], donjaPolovina[donjaPolovina.Count - 1], tacke[i]) < 0) donjaPolovina.RemoveAt(donjaPolovina.Count - 1);
                    donjaPolovina.Add(tacke[i]);
                }

                for (int i = 0; i < gornjaPolovina.Count - 1; i++) omotac.Add(gornjaPolovina[i]);
                for (int i = 0; i < donjaPolovina.Count - 1; i++) omotac.Add(donjaPolovina[i]);
            }

            public long odrediPovrsinu(List<Tacka> tacke)
            {
                long area = 0;
                int n = tacke.Count;
                for (int i = 0; i < n; i++)
                {
                    int j = (i + 1) % n;
                    area += tacke[i].x * tacke[j].y - tacke[j].x * tacke[i].y;
                }
                return Math.Abs(area) / 2;
            }

            public void odrediSkoroOmotac()
            {
                long najmanjaPovrsina = long.MaxValue;
                for (int i = 0; i < omotac.Count; i++)
                {
                    List<Tacka> noviOmotac = omotac.Where((point, index) => index != i).ToList();
                    najmanjaPovrsina = Math.Min(najmanjaPovrsina, odrediPovrsinu(noviOmotac));
                }

                Console.WriteLine(najmanjaPovrsina);
            }
        }

        static void Main(string[] args)
        {
            Mnogougao m = new Mnogougao();

            m.napraviMnogougao();

            m.odrediOmotac();

            m.odrediSkoroOmotac();

            Console.ReadLine();
        }
    }
}